/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.engine.scheduler;

import dev.lambdaurora.lambdynlights.accessor.FrustumStorage;
import dev.lambdaurora.lambdynlights.engine.scheduler.ChunkRebuildScheduler;
import dev.lambdaurora.lambdynlights.engine.scheduler.ChunkRebuildStatus;
import dev.lambdaurora.lambdynlights.engine.source.DynamicLightSource;
import dev.lambdaurora.lambdynlights.util.DynamicLightDebugRenderer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4604;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CullingChunkRebuildScheduler
extends ChunkRebuildScheduler {
    private final Long2ObjectMap<Map<DynamicLightSource, ChunkRebuildStatus>> trackedChunks = new Long2ObjectOpenHashMap();
    private final long[] times = new long[40];
    private int rebuildQueuedLastTick = 0;

    public CullingChunkRebuildScheduler(DynamicLightDebugRenderer.SectionRebuild sectionRebuildDebugRenderer) {
        super(sectionRebuildDebugRenderer);
    }

    public int getRebuildQueuedLastTick() {
        return this.rebuildQueuedLastTick;
    }

    public long getCurrentlyQueued() {
        return this.trackedChunks.long2ObjectEntrySet().stream().filter(trackedChunk -> ((Map)trackedChunk.getValue()).values().stream().anyMatch(status -> status != ChunkRebuildStatus.AFFECTED)).count();
    }

    public float getTickTime() {
        return (float)Arrays.stream(this.times).filter(value -> value > 0L).average().orElse(0.0);
    }

    @Override
    public void appendF3Debug(@NotNull Consumer<String> consumer) {
        consumer.accept("Scheduled Chunk Rebuilds (Culling): %d / %d | Timing: %.3fms (avg. 40t)".formatted(this.getRebuildQueuedLastTick(), this.getCurrentlyQueued(), Float.valueOf(this.getTickTime() / 1000000.0f)));
    }

    @Override
    public void accept(@NotNull DynamicLightSource lightSource, @NotNull Long2ObjectMap<ChunkRebuildStatus> chunks) {
        if (!chunks.isEmpty()) {
            for (Long2ObjectMap.Entry chunk : chunks.long2ObjectEntrySet()) {
                ChunkRebuildStatus newStatus = (ChunkRebuildStatus)((Object)chunk.getValue());
                Map map = (Map)this.trackedChunks.get(chunk.getLongKey());
                if (newStatus == ChunkRebuildStatus.REMOVE_REQUESTED && map == null) continue;
                ChunkRebuildStatus oldStatus = null;
                if (map == null) {
                    map = new Object2ObjectOpenHashMap();
                } else {
                    oldStatus = (ChunkRebuildStatus)((Object)map.get(lightSource));
                }
                if (!(newStatus != ChunkRebuildStatus.REMOVE_REQUESTED || oldStatus != null && oldStatus.needsCleanup())) {
                    map.remove(lightSource);
                } else {
                    map.put(lightSource, oldStatus != null && oldStatus.needsCleanup() && newStatus != ChunkRebuildStatus.REMOVE_REQUESTED ? ChunkRebuildStatus.REQUESTED_AGAIN : newStatus);
                }
                if (map.isEmpty()) {
                    this.trackedChunks.remove(chunk.getLongKey());
                    continue;
                }
                this.trackedChunks.put(chunk.getLongKey(), (Object)map);
            }
        }
    }

    @Override
    public void remove(@NotNull DynamicLightSource lightSource, @NotNull LongSet chunks) {
        LongIterator longIterator = chunks.iterator();
        while (longIterator.hasNext()) {
            long chunk = (Long)longIterator.next();
            Map map = (Map)this.trackedChunks.get(chunk);
            if (map == null) continue;
            ChunkRebuildStatus oldStatus = (ChunkRebuildStatus)((Object)map.get(lightSource));
            if (oldStatus == ChunkRebuildStatus.REQUESTED) {
                map.remove(lightSource);
            } else {
                map.put(lightSource, ChunkRebuildStatus.REMOVE_REQUESTED);
            }
            if (!map.isEmpty()) continue;
            this.trackedChunks.remove(chunk);
        }
    }

    @Override
    public void close() {
        this.sectionRebuildDebugRenderer.clearRequestedChunks();
    }

    @Override
    public void startTick() {
        super.startTick();
        this.rebuildQueuedLastTick = 0;
    }

    @Override
    public void endTick() {
        long startTime = System.nanoTime();
        class_761 renderer = class_310.method_1551().field_1769;
        class_4604 frustum = this.getFrustum(renderer);
        ObjectIterator chunkIt = this.trackedChunks.long2ObjectEntrySet().iterator();
        while (chunkIt.hasNext()) {
            ChunkRebuildStatus status;
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)chunkIt.next();
            long chunkPos = entry.getLongKey();
            Map statusMap = (Map)entry.getValue();
            boolean shouldRebuild = false;
            Iterator iterator = statusMap.values().iterator();
            while (iterator.hasNext() && !(shouldRebuild = (status = (ChunkRebuildStatus)((Object)iterator.next())).needsRebuild())) {
            }
            if (!shouldRebuild) continue;
            int x = class_4076.method_18686((long)chunkPos);
            int y = class_4076.method_18689((long)chunkPos);
            int z = class_4076.method_18690((long)chunkPos);
            int hitResult = frustum == null ? -1 : frustum.method_23089((double)class_4076.method_18688((int)x), (double)class_4076.method_18688((int)y), (double)class_4076.method_18688((int)z), (double)class_4076.method_32205((int)x, (int)16), (double)class_4076.method_32205((int)y, (int)16), (double)class_4076.method_32205((int)z, (int)16));
            boolean isNotCulled = hitResult == -1 || hitResult == -2;
            if (!isNotCulled) continue;
            Iterator it = statusMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry statusEntry = it.next();
                if (statusEntry.getValue() == ChunkRebuildStatus.REMOVE_REQUESTED) {
                    it.remove();
                    continue;
                }
                if (!((ChunkRebuildStatus)((Object)statusEntry.getValue())).needsRebuild()) continue;
                statusMap.put((DynamicLightSource)statusEntry.getKey(), ChunkRebuildStatus.AFFECTED);
            }
            if (statusMap.isEmpty()) {
                chunkIt.remove();
            }
            this.scheduleChunkRebuild(chunkPos);
            ++this.rebuildQueuedLastTick;
        }
        long endTime = System.nanoTime();
        for (int i = 0; i < this.times.length - 1; ++i) {
            this.times[i] = this.times[i + 1];
        }
        this.times[this.times.length - 1] = endTime - startTime;
        this.sectionRebuildDebugRenderer.setRequestedChunks(() -> {
            Long2ObjectOpenHashMap chunks = new Long2ObjectOpenHashMap();
            this.trackedChunks.long2ObjectEntrySet().forEach(trackedChunk -> {
                int[] statuses = new int[ChunkRebuildStatus.VALUES.size()];
                ((Map)trackedChunk.getValue()).values().forEach(status -> {
                    int n = status.ordinal();
                    statuses[n] = statuses[n] + 1;
                });
                chunks.put(trackedChunk.getLongKey(), (Object)statuses);
            });
            return chunks;
        });
    }

    @Nullable
    private class_4604 getFrustum(class_761 renderer) {
        return ((FrustumStorage)renderer).lambdynlights$getFrustum();
    }
}

